# coding: iso-8859-1

module DMK_Constants


  RM03 = "RM03"
  RMXP = "RMXP"
  RMVX = "RMVX"

  F_OPTIONS = "DreaMaker.ini"
  F_POLICE = "polices.dmk-dat"
  F_LANGUAGE = "Languages.csv"

  F_DIAL = "dialogues.txt"
  F_DIAL_AFTER = "dialogues-after.txt"
  F_DIAL_SAVE = "dialogues-save.txt"
  F_DIAL_PATCH = "dialogues-patch.txt"
  F_DIAL_REDIM = "dialogues-redim.txt"
  R_DIAL_VERSION = /DMK ([0-9\.]+)/

  F_POURCENT = "Pourcentage_Maker.txt"
  F_ARCHIVE_TXT = "Environnement/archive.txt"

  F_COMPILER = "Compilation/compiler_infos.rb"
  F_COMPIL = "compil"

  D_BGM = "Audio/BGM"
  D_BGS = "Audio/BGS"
  D_ME = "Audio/ME"
  D_SE = "Audio/SE"



  D_AUTOTILES = "Graphics/Autotiles"
  D_ANIMATIONS = "Graphics/Animations"
  D_BATTLEBACKS = "Graphics/Battlebacks"
  D_BATTLERS = "Graphics/Battlers"
  D_CHARACTERS = "Graphics/Characters"
  D_FOGS = "Graphics/Fogs"
  D_ICONS = "Graphics/Icons"
  D_PANORAMAS = "Graphics/Panoramas"
  D_PICTURES = "Graphics/Pictures"
  D_TILESETS = "Graphics/Tilesets"
  D_TITLES = "Graphics/Titles"
  D_TRANSITIONS = "Graphics/Transitions"
  D_GAMEOVERS = "Graphics/Gameovers"
  D_WINDOWSKINS = "Graphics/Windowskins"

  
  
  R_MAP_RM03 = /Map\d+\.lmu$/
  R_MAP_RMXP = /Map\d+\.rxdata$/
  R_MAP_DMK = /Map\d+\.dmk$/

  R_BD_RMXP_CommonEvent = /CommonEvents\.rxdata$/
  R_BD_RMXP_Item = /Items\.rxdata$/
  R_BD_RMXP_Armor = /Armors\.rxdata$/
  R_BD_RMXP_Actor = /Actors\.rxdata$/
  R_BD_RMXP_State = /States\.rxdata$/
  R_BD_RMXP_Animation = /Animations\.rxdata$/
  R_BD_RMXP_Tileset = /Tilesets\.rxdata$/
  R_BD_RMXP_MapInfo = /MapInfos\.rxdata$/
  R_BD_RMXP_System = /System\.rxdata$/
  R_BD_RMXP_Weapon = /Weapons\.rxdata$/
  R_BD_RMXP_Skill = /Skills\.rxdata$/
  R_BD_RMXP_Class = /Classes\.rxdata$/
  R_BD_RMXP_Enemy = /Enemies\.rxdata$/
  R_BD_RMXP_Troop = /Troops\.rxdata$/

  R_BD_DMK_CommonEvent = Regexp.new(R_BD_RMXP_CommonEvent.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Item = Regexp.new(R_BD_RMXP_Item.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Armor = Regexp.new(R_BD_RMXP_Armor.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Actor = Regexp.new(R_BD_RMXP_Actor.source.gsub("rxdata", "dmk"))
  R_BD_DMK_State = Regexp.new(R_BD_RMXP_State.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Animation = Regexp.new(R_BD_RMXP_Animation.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Tileset = Regexp.new(R_BD_RMXP_Tileset.source.gsub("rxdata", "dmk"))
  R_BD_DMK_MapInfo = Regexp.new(R_BD_RMXP_MapInfo.source.gsub("rxdata", "dmk"))
  R_BD_DMK_System = Regexp.new(R_BD_RMXP_System.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Weapon = Regexp.new(R_BD_RMXP_Weapon.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Skill = Regexp.new(R_BD_RMXP_Skill.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Class = Regexp.new(R_BD_RMXP_Class.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Enemy = Regexp.new(R_BD_RMXP_Enemy.source.gsub("rxdata", "dmk"))
  R_BD_DMK_Troop = Regexp.new(R_BD_RMXP_Troop.source.gsub("rxdata", "dmk"))
  


  r = []
  r << R_BD_RMXP_CommonEvent
  r << R_BD_RMXP_Item
  r << R_BD_RMXP_Armor
  r << R_BD_RMXP_Actor
  r << R_BD_RMXP_State
  r << R_BD_RMXP_Animation
  r << R_BD_RMXP_Tileset
  r << R_BD_RMXP_MapInfo
  r << R_BD_RMXP_System
  r << R_BD_RMXP_Weapon
  r << R_BD_RMXP_Skill
  r << R_BD_RMXP_Class
  r << R_BD_RMXP_Enemy
  r << R_BD_RMXP_Troop
  r_str = ""
  r.each{|x| r_str << x.source+"|"}
  r_str.pop!

  R_BD_RM03 = /RPG_RTt\.ldb$/
  R_BD_RMXP = Regexp.new(r_str)


  #R_BD_DMK = /CommonEvents\.dmk/
  R_BD_DMK = Regexp.new(R_BD_RMXP.source.gsub("rxdata", "dmk"))
  


  MAX_CARAC = 64

  CARAC_MESS = '-'
  CARAC_SLOT = '+'
  CARAC_FIN = '_'
  CARAC_MAP = '#'
  CARAC_EVENT = '/'
  CARAC_PAGE = '_'



  CARAC_ITEM = '_'



  

  L_CODE_TEXT = [101, 401, 102, 402]


  # Code des instructions RMXP
  CODE_EMPTY_LINE = 0

  CODE_MESSAGE = 101
  CODE_SLOT = 102
  CODE_NUMBER_INPUT = 103
  CODE_WAIT = 106
  CODE_COMMENTARY = 108
  CODE_LOOP = 112
  CODE_LOOP_BREAK = 113
  CODE_EVENT_DELETE = 116
  CODE_STICKER = 118
  CODE_STICKER_END = 119
  CODE_VARIABLE = 122

  CODE_WINDOWSKIN = 131
  CODE_CHANGE_MUSIC_BATTLE = 132
  CODE_CHANGE_MUSIC_VICTORY = 133
  CODE_SAVE_AUTHORIZE = 134

  CODE_PROPRIETE_MAP = 204
  CODE_MOVE_EVENT = 209
  CODE_TRANSITION = 222
  CODE_PICTURE_SHOW = 231
  CODE_BGM_PLAY = 241
  CODE_BGS_PLAY = 245
  CODE_ME_PLAY = 249
  CODE_SE_PLAY = 250

  CODE_GAME_OVER = 353
  CODE_TITLE = 354

  CODE_MESSAGE_SUITE = 401
  CODE_SLOT_SUITE = 402
  CODE_SLOT_END = 404
  CODE_COMMENTARY_SUITE = 408
  CODE_LOOP_END = 413
  CODE_MOVE_EVENT_SUITE = 509



  # Code des instructions RM03
  CODE_EMPTY_LINE_RM03 = 10
  CODE_MESSAGE_RM03 = 10110
  CODE_SLOT_RM03 = 10140
  CODE_MESSAGE_SUITE_RM03 = 20110
  CODE_WAIT_RM03 = 11410
  CODE_LOOP_RM03 = 12210
  CODE_LOOP_BREAK_RM03 = 12220
  CODE_LOOP_END_RM03 = 22210
  CODE_EVENT_DELETE_RM03 = 12320
  CODE_COMMENTARY_RM03 = 12410
  CODE_GAME_OVER_RM03 = 12420
  CODE_TITLE_RM03 = 12510
  CODE_SLOT_SUITE_RM03 = 20140
  CODE_SLOT_END_RM03 = 20141
  CODE_SAVE_AUTHORIZE_RM03 = 11930
  CODE_STICKER_RM03 = 12110
  CODE_STICKER_END_RM03 = 12120

  CODE_NUMBER_INPUT_RM03 = 10150
  

  # Code des instructions spcifiques  RM03
  CODE_MESSAGE_FACE = 10130
  CODE_PAGE_END_RM03 = 0
  CODE_CHANGE_NAME_RM03 = 10610
  CODE_SCREEN_ERASE_RM03 = 11010
  

  # Pour la gestion des nombres ngatifs dans RM03
  RM03_NUMBER_MAX = 256**4
  RM03_NUMBER_MIDDLE = RM03_NUMBER_MAX / 2




  R_LIRE_MAPS = /Map:(\d+):(\d+):(\d+):(\d+)\]\n(.*?)\n(?:(?:-|\+){15,}\[|_{60})/m

  R_LIRE_ACTORS = /_{15}\[Actor:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_ANIMATIONS = /_{15}\[Animation:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_ARMORS = /_{15}\[Armor:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_CLASSES = /_{15}\[Class:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_COMMON_EVENTS = /Com Ev:(\d+):(\d+)\]\n(.*?)\n(?:(?:-|\+){15,}\[|_{60})/m
  R_LIRE_ENEMIES = /_{15}\[Enemy:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_ITEMS = /_{15}\[Item:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_MAP_INFOS = /_{15}\[Map Info:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_SKILLS = /_{15}\[Skill:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_STATES = /_{15}\[State:(\d+)\]\n(.*?)\n_{15}/m
  #R_LIRE_SYSTEM_WORDS = /((?:Gold|Hp|Sp|Strength|Dexterity|Agility|Intelligence|Atk|Physical Defense|Magical Defense|Weapon|Armor1|Armor2|Armor3|Armor4|Attack|Skill|Guard|Item|Equip))\]\n(.*?)(?:_{15,}\[|_{60})/m
  #R_LIRE_SYSTEM_WORDS = /((?:Gold|Hp|Sp|Strength|Dexterity|Agility|Intelligence))\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_SYSTEM_WORDS = /_{15}\[((?:Gold|Hp|Sp|Strength|Dexterity|Agility|Intelligence))\]\n(.*?)\n_{15}/m
  #R_LIRE_SYSTEM_WORDS = /__\[(Gold)\]\n(.*?)(?:_{15,}__|_{60})/m
  R_LIRE_SYSTEM_ELEMENTS = /_{15}\[Element:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_TILESETS = /_{15}\[Tileset:(\d+)\]\n(.*?)\n_{15}/m
  R_LIRE_TROOPS = /Troop:(\d+):(\d+):(\d+)\]\n(.*?)\n(?:(?:-|\+){15,}\[|_{60})/m
  R_LIRE_WEAPONS = /_{15}\[Weapon:(\d+)\]\n(.*?)\n_{15}/m

=begin
  R_LIRE_MAPS = /Map:(\d+):(\d+):(\d+):(\d+)\]\n(.*?)(?:(?:-|\+){15,}\[|_{60})/m

  R_LIRE_ACTORS = /Actor:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_ANIMATIONS = /Animation:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_ARMORS = /Armor:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_CLASSES = /Class:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_COMMON_EVENTS = /Com Ev:(\d+):(\d+)\]\n(.*?)(?:(?:-|\+){15,}\[|_{60})/m
  R_LIRE_ENEMIES = /Enemy:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_ITEMS = /Item:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_MAP_INFOS = /Map Info:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_SKILLS = /Skill:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_STATES = /State:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_SYSTEM_WORDS = /((?:Gold|Hp|Sp|Strength|Dexterity|Agility|Intelligence|Atk|Physical Defense|Magical Defense|Weapon|Armor1|Armor2|Armor3|Armor4|Attack|Skill|Guard|Item|Equip))\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_SYSTEM_WORDS = /((?:Gold|cal Defense|Weapon|Armor1|Armor2|Armor3|Armor4|Attack|Skill|Guard|Item|Equip))\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_SYSTEM_ELEMENTS = /Element:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_TILESETS = /Tileset:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m
  R_LIRE_TROOPS = /Troop:(\d+):(\d+):(\d+)\]\n(.*?)(?:(?:-|\+){15,}\[|_{60})/m
  R_LIRE_WEAPONS = /Weapon:(\d+)\]\n(.*?)(?:_{15,}\[|_{60})/m

=end



  R_HASH_LOAD = {
    R_LIRE_ACTORS => :load_actors,
    R_LIRE_ANIMATIONS => :load_animations,
    R_LIRE_ARMORS => :load_armors,
    R_LIRE_CLASSES => :load_classes,
    R_LIRE_COMMON_EVENTS => :load_common_events,
    R_LIRE_ENEMIES => :load_enemies,
    R_LIRE_ITEMS => :load_items,
    R_LIRE_MAP_INFOS => :load_map_infos,
    R_LIRE_SKILLS => :load_skills,
    R_LIRE_STATES => :load_states,
    R_LIRE_TILESETS => :load_tilesets,
    R_LIRE_TROOPS => :load_troops,
    R_LIRE_WEAPONS => :load_weapons
  }

  R_HASH_SAVE = {
    R_LIRE_ACTORS => :save_actors,
    R_LIRE_ANIMATIONS => :save_animations,
    R_LIRE_ARMORS => :save_armors,
    R_LIRE_CLASSES => :save_classes,
    R_LIRE_COMMON_EVENTS => :save_common_events,
    R_LIRE_ENEMIES => :save_enemies,
    R_LIRE_ITEMS => :save_items,
    R_LIRE_MAP_INFOS => :save_map_infos,
    R_LIRE_SKILLS => :save_skills,
    R_LIRE_STATES => :save_states,
    R_LIRE_TILESETS => :save_tilesets,
    R_LIRE_TROOPS => :save_troops,
    R_LIRE_WEAPONS => :save_weapons
  }



  DMK_WEBSITE = "http://www.kadelfek.com/dreamaker"


end